--
-- Geometry Metadata
-- 

delete from user_sdo_geom_metadata
	where table_name = 'SPATIAL_NET_NODE$'; 

delete from user_sdo_geom_metadata
	where table_name = 'SPATIAL_NET_LINK$'; 

insert into user_sdo_geom_metadata 
	values ( 'SPATIAL_NET_NODE$',
		 'GEOMETRY', 
		 MDSYS.SDO_DIM_ARRAY (
                 MDSYS.SDO_DIM_ELEMENT('X', 0, 100, 0.005),
                 MDSYS.SDO_DIM_ELEMENT('Y', 0, 100, 0.005)),
		 0);

insert into user_sdo_geom_metadata 
	values ( 'SPATIAL_NET_LINK$',
		 'GEOMETRY', 
		 MDSYS.SDO_DIM_ARRAY (
                 MDSYS.SDO_DIM_ELEMENT('X', 0, 100, 0.005),
                 MDSYS.SDO_DIM_ELEMENT('Y', 0, 100, 0.005)),
		 0);


--
-- Network Metadata
--

delete from user_sdo_network_metadata where network = 'SPATIAL_NET';

insert into user_sdo_network_metadata ( network, 
                                        network_category,
				        geometry_type,
                                        node_table_name,
					node_geom_column,
                                        link_table_name,
					link_geom_column,
                                        link_cost_column,
                                        link_direction )
                                      values 
                                      ( 'SPATIAL_NET',
                                        'SPATIAL', 
					'SDO_GEOMETRY',
                                        'SPATIAL_NET_NODE$',
			                'GEOMETRY',
                                        'SPATIAL_NET_LINK$',
			                'GEOMETRY',
                                        'COST',
                                        'DIRECTED');

